/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.adempiere.base.IProcessFactory;
import org.adempiere.base.MappedByNameFactory;
import org.adempiere.base.annotation.Process;
import org.compiere.process.ProcessCall;
import org.compiere.util.CLogger;
import org.idempiere.process.IMappedProcessFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;

@Component(name="org.idempiere.process.MappedProcessFactory", immediate=true, service={IProcessFactory.class, IMappedProcessFactory.class}, property={"service.ranking:Integer=1"})
public class MappedProcessFactory
extends MappedByNameFactory<ProcessCall>
implements IProcessFactory,
IMappedProcessFactory {
    private static final CLogger s_log = CLogger.getCLogger(MappedProcessFactory.class);

    @Override
    public ProcessCall newProcessInstance(String className) {
        return (ProcessCall)this.newInstance(className);
    }

    @Override
    public void scan(BundleContext context, String ... packages) {
        ClassLoader classLoader = ((BundleWiring)context.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning().acceptPackagesNonRecursive(packages);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ScanResult scanResult = graph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Process.class)) {
                if (classInfo.isAbstract()) continue;
                String className = classInfo.getName();
                try {
                    Class clazz = classInfo.loadClass();
                    Constructor constructor = clazz.getConstructor(new Class[0]);
                    ProcessCallSupplier supplier = new ProcessCallSupplier(constructor);
                    AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Process.class);
                    String alternateName = null;
                    if (annotationInfo != null) {
                        alternateName = (String)annotationInfo.getParameterValues().getValue("name");
                    }
                    this.addMapping(className, supplier);
                    if (alternateName == null) continue;
                    this.addMapping(alternateName, supplier);
                }
                catch (Exception e) {
                    if (!s_log.isLoggable(Level.INFO)) continue;
                    s_log.log(Level.INFO, e.getMessage(), e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static final class ProcessCallSupplier
    implements Supplier<ProcessCall> {
        private Constructor<? extends ProcessCall> constructor;

        private ProcessCallSupplier(Constructor<? extends ProcessCall> constructor) {
            this.constructor = constructor;
        }

        @Override
        public ProcessCall get() {
            if (this.constructor != null) {
                try {
                    return this.constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    s_log.log(Level.WARNING, e.getMessage(), e);
                    this.constructor = null;
                }
            }
            return null;
        }
    }
}

